/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.gui.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.nio.charset.Charset;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.border.BevelBorder;
import net.miginfocom.swing.MigLayout;
import net.nooj4nlp.engine.Language;
import net.nooj4nlp.engine.SystemEnvironment;
import net.nooj4nlp.gui.actions.grammar.ImportGrammarActionListener;
import net.nooj4nlp.gui.dialogs.OpenGrammarButtonActionListener;
import net.nooj4nlp.gui.main.Launcher;

public class OpenGrammarDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private ImportGrammarActionListener importGrammarListener;
    private int indexOfDefaultEncoding;
    private JList fileFormatList;
    private JList inputLanguageList;
    private JList outputLanguageList;
    private JButton inflectionalGrammarButton;
    private JButton morphologicalGrammarButton;
    private JButton syntacticGrammarButton;

    public OpenGrammarDialog(ImportGrammarActionListener importGrammarListener, int selectedIndexOfFileFormats) {
        this.importGrammarListener = importGrammarListener;
        this.indexOfDefaultEncoding = Launcher.getIndexOfDefaultEncoding();
        this.setTitle("Import a graph and its embedded graphs");
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.setBounds(50, 50, 550, 280);
        this.getContentPane().setLayout((LayoutManager)new MigLayout("insets 5", "[][][]", "[::40][grow][::50]"));
        JLabel inputLanguageLabel = new JLabel("Input Language:");
        this.getContentPane().add((Component)inputLanguageLabel, "cell 0 0, gaptop 20, align center");
        JLabel outputLanguageLabel = new JLabel("Output Language:");
        this.getContentPane().add((Component)outputLanguageLabel, "cell 1 0, gaptop 20, align center");
        JLabel fileFormatLabel = new JLabel("File Format:");
        this.getContentPane().add((Component)fileFormatLabel, "cell 2 0, gaptop 20, align left");
        DefaultListModel<String> inputModel = new DefaultListModel<String>();
        DefaultListModel<String> outputModel = new DefaultListModel<String>();
        this.inputLanguageList = new JList(inputModel);
        this.outputLanguageList = new JList(outputModel);
        for (String language : Language.getAllLanguages()) {
            inputModel.addElement(language);
            outputModel.addElement(language);
        }
        this.inputLanguageList.setSelectedValue(Launcher.preferences.deflanguage, true);
        this.inputLanguageList.setSelectionMode(0);
        this.inputLanguageList.setBorder(new BevelBorder(1, null, null, null, null));
        JScrollPane scrollInputLanguages = new JScrollPane(this.inputLanguageList);
        scrollInputLanguages.setPreferredSize(new Dimension(50, 150));
        this.getContentPane().add((Component)scrollInputLanguages, "cell 0 1, align center");
        this.inputLanguageList.ensureIndexIsVisible(this.inputLanguageList.getSelectedIndex());
        this.outputLanguageList.setSelectedValue(Launcher.getIndexOfDefaultEncoding(), true);
        this.outputLanguageList.setSelectionMode(0);
        this.outputLanguageList.setBorder(new BevelBorder(1, null, null, null, null));
        JScrollPane scrollOutputLanguages = new JScrollPane(this.outputLanguageList);
        scrollOutputLanguages.setPreferredSize(new Dimension(50, 150));
        this.getContentPane().add((Component)scrollOutputLanguages, "cell 1 1, align center");
        this.outputLanguageList.ensureIndexIsVisible(this.outputLanguageList.getSelectedIndex());
        DefaultListModel<String> model = new DefaultListModel<String>();
        this.fileFormatList = new JList(model);
        this.fileFormatList.setSelectionMode(0);
        this.fileFormatList.setBorder(new BevelBorder(1, null, null, null, null));
        JScrollPane scrollFileFormat = new JScrollPane(this.fileFormatList);
        scrollFileFormat.setPreferredSize(new Dimension(250, 150));
        this.getContentPane().add((Component)scrollFileFormat, "cell 2 1, align center");
        int n = SystemEnvironment.encodings.length;
        for (int i = 0; i < n; ++i) {
            String e = SystemEnvironment.encodings[i];
            if (e.startsWith("UTF-8") && this.indexOfDefaultEncoding == -1) {
                this.indexOfDefaultEncoding = i;
            }
            Charset c = Charset.forName(e);
            e = e + c.aliases().toString();
            model.add(i, e);
        }
        this.fileFormatList.setSelectedIndex(this.indexOfDefaultEncoding);
        this.fileFormatList.ensureIndexIsVisible(this.indexOfDefaultEncoding);
        OpenGrammarButtonActionListener openGrammarListener = new OpenGrammarButtonActionListener(this, this.importGrammarListener);
        this.inflectionalGrammarButton = new JButton("Inflectional Grammar");
        this.getContentPane().add((Component)this.inflectionalGrammarButton, "cell 0 2, align center");
        this.inflectionalGrammarButton.setActionCommand("Inflectic");
        this.inflectionalGrammarButton.addActionListener(openGrammarListener);
        this.morphologicalGrammarButton = new JButton("Morphological Grammar");
        this.getContentPane().add((Component)this.morphologicalGrammarButton, "cell 1 2, align center");
        this.morphologicalGrammarButton.setActionCommand("Morphologic");
        this.morphologicalGrammarButton.addActionListener(openGrammarListener);
        this.syntacticGrammarButton = new JButton("Syntactic Grammar");
        this.getContentPane().add((Component)this.syntacticGrammarButton, "cell 2 2, align center");
        this.syntacticGrammarButton.setActionCommand("Syntactic");
        this.syntacticGrammarButton.addActionListener(openGrammarListener);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                Launcher.setIndexOfDefaultEncoding(OpenGrammarDialog.this.fileFormatList.getSelectedIndex());
            }
        });
    }

    public JList getInputLanguageList() {
        return this.inputLanguageList;
    }

    public JList getOutputLanguageList() {
        return this.outputLanguageList;
    }

    public JList getFileFormatList() {
        return this.fileFormatList;
    }

    public JButton getInflectionalGrammarButton() {
        return this.inflectionalGrammarButton;
    }

    public JButton getMorphologicalGrammarButton() {
        return this.morphologicalGrammarButton;
    }

    public JButton getSyntacticGrammarButton() {
        return this.syntacticGrammarButton;
    }
}

